function get_few_verbs_lists(choices) {
    var useful = [];
    var possible = [];
    for (var i = choices.length; i--;) {
	var candidate = choices[i].command.toLowerCase();
	if (candidate.indexOf('(') < 0) {
	    var ellipsis_index = candidate.indexOf('…');
	    if (ellipsis_index >= 0) {
		var filter = candidate.slice(0, ellipsis_index);
		matches = $.grep(choices, function(element) {
		    var command = element.command.toLowerCase();
		    return (command != candidate) && (command.indexOf(filter) == 0);
		});
		possible = possible.concat([filter.trim()]);
		if (matches.length > 0) {
		    useful = useful.concat([filter.trim()]);
		}
	    }	    
	}
    }
    return {possible: possible, useful: useful};
}

function autocomplete(prefix, choices) {
    var downcased_prefix = prefix.trim().toLowerCase();
    var forbidden_ellipsis_index = (prefix.slice(-1) == ' ') ? downcased_prefix.length + 1 : -1;
    var candidates = $.grep(choices, function(element) {
        return (element.command.toLowerCase().indexOf(downcased_prefix) == 0) && (element.command[forbidden_ellipsis_index] != '…');
    });
    var filtered_candidates = candidates;
    for (var i = candidates.length; i--;) {
	var candidate = candidates[i].command.toLowerCase();
	var ellipsis_index = candidate.indexOf('…');
	if (ellipsis_index >= 0) {
	    var filter = candidate.slice(0, ellipsis_index);
	    filtered_candidates = $.grep(filtered_candidates, function(element) {
		var command = element.command.toLowerCase();
		return (command == candidate) || (command.indexOf(filter) != 0);
	    });
	}
    }
    return filtered_candidates;
}

// Return each element of choices whose command is prefix.
function autocomplete_exact(prefix, choices) {
    var downcased_prefix = prefix.trim().toLowerCase();
    return $.grep(choices, function(element) {
        return (element.command.toLowerCase() === downcased_prefix);
    });
}

(function($) {
    $.widget('ui.parser_choice_hybrid', {
	options: {
	    // The placeholder text that appears when the text box contains no text.
	    prompt: 'Have the protagonist…',

	    // The commands and partial commands (which contain ellipses) available.
	    // See below for examples of each.
            choices: [
		{ command: 'do …', thought: 'No choices have been implemented here.' },
		{ command: 'do nothing', thought: 'No choices have been implemented here.' }
	    ],

	    // The text that appears instead of autocompletions when there are no matches.
	    no_matches_text: '(There are no matching choices.)',

	    suggestion_thresholds: [2, 2, 1, 1],

	    handler: function(choice){}
	},

	_prior_prefix_length: 0,
	_prefix_is_shortening: false,
	_suggestion_threshold_index: 0,

        _create: function() {
            var that = this;

            this.element.addClass('parser-choice-hybrid ui-widget ui-widget-content ui-corner-all transient');

            this.textbox = $('<input type="text">');
	    this.textbox.addClass('parser-choice-hybrid ui-widget-content');
            this.textbox.attr('placeholder', this.options.prompt);

	    this.textbox.on('input', function(event) {
		var untrimmed_prefix = that.textbox.val();
		var prefix = untrimmed_prefix.trim();

		if (that._prior_prefix_length > prefix.length) {
		    if (!that._prefix_is_shortening) {
			that._prefix_is_shortening = true;
			++that._suggestion_threshold_index;
		    }
		} else if (that._prior_prefix_length < prefix.length &&
			   (!that.suggestions.children('li').length ||
			    that.suggestions.children('li.parser-choice-hybrid-active').length)) {
		    that._prefix_is_shortening = false;
		}
		that._prior_prefix_length = prefix.length;

		that.suggestions.empty();

		if (that._suggestion_threshold_index >= that.options.suggestion_thresholds.length || prefix.length >= that.options.suggestion_thresholds[that._suggestion_threshold_index] || (prefix.length > 0 && untrimmed_prefix.slice(-1) == ' ')) {
		    var suggestion_elements = $.map(autocomplete(untrimmed_prefix, that.options.choices), function(autocompletion, index) {
			var suggestion_element = $('<li></li>');
			suggestion_element.append($('<span></span>').addClass('command').text(autocompletion.command));
			if (typeof autocompletion.thought !== 'undefined') {
			    suggestion_element.append($('<br>'));
			    suggestion_element.append($('<span></span>').addClass('thought').text(autocompletion.thought));
			}
			suggestion_element.on('click', function(event) {
			    that.suggestions.children('li.parser-choice-hybrid-active').each(function() {
				$(this).removeClass('parser-choice-hybrid-active');
			    });
			    $(this).addClass('parser-choice-hybrid-active');
			    that.textbox.trigger($.Event('keydown', { which: $.ui.keyCode.ENTER }));
			});
			return suggestion_element;
		    });
		    if (suggestion_elements.length > 0) {
			suggestion_elements[0].addClass('parser-choice-hybrid-active');
			that.suggestions.append(suggestion_elements);
		    } else {
			that.suggestions.append($('<li></li>').addClass('non-option').text(that.options.no_matches_text));
		    }
		}

		var scroll = that.suggestions_container.data('__jsFancyScroll');
		if (typeof scroll !== 'undefined') {
		    scroll.update();
		}
	    });

            this.textbox.on('keydown', function(event) {
		var active_suggestion = that.suggestions.children('li.parser-choice-hybrid-active');
		if (active_suggestion.length) {
		    switch (event.which) {
		    case $.ui.keyCode.UP:
			var previous = active_suggestion.prev('li');
			if (!previous.length) {
			    previous = that.suggestions.children('li:last');
			}
			active_suggestion.removeClass('parser-choice-hybrid-active');
			previous.addClass('parser-choice-hybrid-active');
			that.suggestions_viewport.stop();
			that.suggestions_viewport.animate({ scrollTop: that.suggestions_viewport.scrollTop() + previous.offset().top - that.suggestions_viewport.offset().top });
			break;
		    case $.ui.keyCode.DOWN:
			var next = active_suggestion.next('li');
			if (!next.length) {
			    next = that.suggestions.children('li:first');
			}
			active_suggestion.removeClass('parser-choice-hybrid-active');
			next.addClass('parser-choice-hybrid-active');
			that.suggestions_viewport.stop();
			that.suggestions_viewport.animate({ scrollTop: that.suggestions_viewport.scrollTop() + next.offset().top - that.suggestions_viewport.offset().top });
			break;
		    case $.ui.keyCode.ENTER:
			event.preventDefault();
			var unexpanded_prefix = that.textbox.val();
			var command = active_suggestion.children('span.command').text();
			var expanded_prefix = command.replace(/….*/, '');
			var incomplete = (command.indexOf('…') != -1);
			if (unexpanded_prefix != expanded_prefix) {
			    that.textbox.val(expanded_prefix);
			    if (incomplete) {
				that.textbox.trigger('input');
			    }
			}
			if (!incomplete) {
			    var autocompletions = autocomplete_exact(expanded_prefix, that.options.choices);
			    if (autocompletions.length == 1) {
				that.options.handler(autocompletions[0]);
			    }
			}
			break;
		    case $.ui.keyCode.TAB:
			var unexpanded_prefix = that.textbox.val();
			var command = active_suggestion.children('span.command').text();
			var expanded_prefix = command.replace(/….*/, '');
			if (unexpanded_prefix != expanded_prefix) {
			    event.preventDefault();
			    that.textbox.val(expanded_prefix).trigger('input');
			}
			break;
		    }
		}
            });

	    this.element.append(this.textbox);

            this.suggestions = $('<ul></ul>');
	    this.suggestions.addClass('parser-choice-hybrid ui-widget-content');
	    this.suggestions_content = $('<div></div>');
	    this.suggestions_content.addClass('content');
	    this.suggestions_content.append(this.suggestions);
	    this.suggestions_viewport = $('<div></div>');
	    this.suggestions_viewport.addClass('viewport');
	    this.suggestions_viewport.append(this.suggestions_content);
            this.suggestions_container = $('<ul></ul>');
	    this.suggestions_container.addClass('options scrollY myScroll');
	    this.suggestions_container.append(this.suggestions_viewport);
	    this.element.append(this.suggestions_container);
        },

        destroy: function() {
            $.Widget.prototype.destroy.call(this);

	    this.element.removeClass('parser-choice-hybrid ui-widget ui-widget-content ui-corner-all');
	    this.textbox.removeClass('parser-choice-hybrid ui-widget-content');
	    this.suggestions_container.removeClass('parser-choice-hybrid ui-widget-content options');
	    this.suggestions_content.removeClass('content');
	    this.suggestions_viewport.removeClass('viewport');
	    this.suggestions_container.removeClass('scrollY myScroll');
	    this.suggestions.empty();

            return this;
        },
    });
})(jQuery);
